#!/system/xbin/bash

function start_usbnet() {
    echo starting usbnet
    devname=$(netcfg | grep -e 'rndis0\|usb0' | awk '{print $1}')
    if test -z "$devname"; then
        echo Error: usbnet device not found
        exit
    fi
    netcfg $devname up
    ifconfig $devname 192.168.42.129
    ifconfig $devname:0 192.168.43.129
    echo start usbnet done
}

set -x

if cat /proc/cmdline|grep androidboot.bsp=1; then
    for v in "" v3; do
	if test -e /dev/block/platform/sdhci-pxa$v.2/by-name/cache; then
	    setup_fs /dev/block/platform/sdhci-pxa$v.2/by-name/cache || true
	fi
    done
fi

for v in "" v3; do
    for name in cache factory; do
	if test $name = cache; then
	    if ! cat /proc/cmdline|grep androidboot.bsp=1; then
		# Don't re-mount cache in normal android mode, because
		# the setup_fs service in init.rc might be
		# running. When mount and setup_fs run at the same
		# time, the partition might be damaged.
		continue
	    fi
	fi
	mount -o rw -t ext4 /dev/block/platform/sdhci-pxa$v.2/by-name/$name /$name || true
    done
done

(
    if test -e /factory/battery-firmware-updated; then
        exit 0
    fi
    echo update > /sys/class/power_supply/battery/device/update
    touch /factory/battery-firmware-updated
)&

(
    flock 9
    if test -e /factory/mac-random-done2; then
        exit 0
    fi

    cid=$(find /sys -name '*id'|xargs cat 2>/dev/null|md5sum|awk '{print $1}')
    wifi_mac=$(awk 'BEGIN{srand('0x$(echo $cid|cut -b 8-15)'); for(i=0; i<6; i++) {printf "%x%x:", rand()*16, rand()*16}}'|cut -b '1-17')
    bt_mac=$(awk 'BEGIN{srand('0x$(echo $cid|cut -b 9-16)'); for(i=0; i<6; i++) {printf "%x%x:", rand()*16, rand()*16}}'|cut -b '1-17')
    wifi_mac=$(echo $wifi_mac | sed -e 's!^..:..:..!00:50:43!')
    bt_mac=$(echo $bt_mac | sed -e 's!^..:..:..!00:50:43!')
    for x in $(seq 1 5); do
        (
            set -e
            tcmd-subcase.sh wifi-set-mac $wifi_mac|tail -n 1|grep -e 'ret: 0$'
            tcmd-subcase.sh bt-set-mac $bt_mac|tail -n 1|grep -e 'ret: 0$'
            touch /factory/mac-random-done2
        ) && break || true
        sleep 1
    done
) 9>/factory/set-mac-lock || true&

(
    IFS=$'\n';
    for x in $(fw_printenv); do
        name=$(echo "$x"|sed -e 's/=.*//');
        value=$(echo "$x"|sed -e 's/.*=//');
        if echo "$name"|grep -e '^[a-z0-9]\+$' -i -q && test ${#name} -lt 10 && test ${#value} -lt 10; then
            setprop persist.uboot.env.$name "$value"
        fi
    done
)&
        
if cat /proc/cmdline|grep androidboot.bsp=1; then
    for x in $(cat /etc/powerhal.conf|grep '^/'); do
	echo on > $x/control
    done    
    mkdir -p /data/vendor
    for v in "" v3; do
        mount -t ext4 /dev/block/platform/sdhci-pxa$v.2/by-name/toolUMS /data/vendor || true
    done
    start_usbnet
else
    if test "$(getprop persist.sys.usb.config)" = rndis,adb; then
	start_usbnet
    fi

    if test -e /factory/shipped-product; then
	stop tcmdd
	for x in $(seq 1 10); do
	    (
		sleep 1;
		stop tcmdd
	    )
	done&
    fi
fi&

if cat /proc/cmdline|grep console=ttyGS; then
    usbconf=$(getprop persist.sys.usb.config)
    if test "$usbconf" && ! echo $usbconf|grep -q -e "\bacm\b"; then
        setprop persist.sys.usb.config $usbconf,acm
    fi
fi&

