#!/system/bin/sh
for x in $(cat /proc/cmdline); do
	case $x in
		simcard=*)
			simcard=${x#simcard=}
			;;
	esac
done

#For Single SIM solution, only care about SIM1
dualsimsolution=`getprop ro.cmd.DUAL_SIMCARD`
if [ "$dualsimsolution" != "true" ] ;then
case "$simcard" in
	"0"|"2")
		simcard="0"
		;;
	*)
		simcard="1"
		;;
esac
fi

setprop sys.telephony.default.loglevel 8

MODULE_DIR=/lib/modules
insmod $MODULE_DIR/msocketk.ko simcard=${simcard}
insmod $MODULE_DIR/cploaddev.ko
insmod $MODULE_DIR/seh.ko
# load cp and mrd image and release cp
/system/bin/cploader

ret="$?"


if [ ! -e $NVM_ROOT_DIR ]; then
	mkdir -p $NVM_ROOT_DIR
	chown system.system $NVM_ROOT_DIR
fi

if [ ! -e $MARVELL_RW_DIR ]; then
	mkdir -p $MARVELL_RW_DIR
	chown system.system $MARVELL_RW_DIR
	chmod 0755 $MARVELL_RW_DIR
fi

case "$ret" in
	    "-1")
		rmmod seh
		rmmod cploaddev
		rmmod msocketk
		stop ril-daemon
		exit
       ;;
	    "1")
		rmmod seh
		rmmod cploaddev
		rmmod msocketk
		stop ril-daemon
		start nvm-aponly
		start diag-aponly
		insmod $MODULE_DIR/citty.ko
		start atcmdsrv-aponly
		exit
       ;;
       *)
       ;;
esac

# $1 src file
# $2 dst file
function copy_if_not_exist()
{
if [ -f "${2}" ]; then
	echo "existing ${2}";
else
	if [ -f "${1}" ]; then
		cp ${1} ${2}
		chmod 666 ${2}
		chown system.system ${2}
		echo "cp: ${1} -> ${2}"
	fi
fi
}

kernel_cmdline=`cat /proc/cmdline`

T7_BOARDID="board_id=0x7"

function is_t7_board()
{
	if [[ "$kernel_cmdline" == *$T7_BOARDID* ]]
	then
		return 0
	else
		return 1
	fi
}

B5_BOARD="band_type=0x5"
function is_b5_board()
{
	if [[ "$kernel_cmdline" == *$B5_BOARD* ]]
	then
		return 0
	else
		return 1
	fi
}

# copy correct RF config file for CP
# pxa986 T7 board -> T7 specific
cputype=`cat /sys/devices/system/cpu/cpu0/cputype`
case "$cputype" in
    "pxa986ax"|"pxa986zx"|"pxa1088")
	if is_b5_board; then
		rfcfg_src="rfcfg/LyraConfig_B5.nvm"
		rfcfg_dst="LyraConfig.nvm"
		gkicfg_src="rfcfg/TTPCom_NRAM2_ABMM_WRITEABLE_DATA_B5.gki"
		gkicfg_dst="TTPCom_NRAM2_ABMM_WRITEABLE_DATA.gki"
	else
		rfcfg_src="rfcfg/LyraConfig_B8.nvm"
		rfcfg_dst="LyraConfig.nvm"
		gkicfg_src="rfcfg/TTPCom_NRAM2_ABMM_WRITEABLE_DATA_B8.gki"
		gkicfg_dst="TTPCom_NRAM2_ABMM_WRITEABLE_DATA.gki"
	fi
	;;
	*)
	rfcfg_src=""
	rfcfg_dst=""
	gkicfg_src=""
	gkicfg_dst=""
	;;
esac

copy_if_not_exist "/etc/tel/${rfcfg_src}" "${NVM_ROOT_DIR}/${rfcfg_dst}"
copy_if_not_exist "/etc/tel/${gkicfg_src}" "${NVM_ROOT_DIR}/${gkicfg_dst}"

comcfg_src="rfcfg/COMCfg.csv"
comcfg_dst="COMCfg.csv"
copy_if_not_exist "/etc/tel/${comcfg_src}" "${NVM_ROOT_DIR}/${comcfg_dst}"
insmod $MODULE_DIR/citty.ko
insmod $MODULE_DIR/cci_datastub.ko
insmod $MODULE_DIR/ccinetdev.ko
insmod $MODULE_DIR/gs_modem.ko
insmod $MODULE_DIR/cidatattydev.ko
insmod $MODULE_DIR/usimeventk.ko

sync

start eeh
start nvm
start diag
start atcmdsrv
start vcm
